from abc import ABCMeta, abstractmethod
from six import add_metaclass


@add_metaclass(ABCMeta)
class ProviderInterface():
    @abstractmethod
    def connect(self):
        """Create a new session."""
        raise NotImplementedError()

    @abstractmethod
    def disconnect(self):
        """Delete session."""
        raise NotImplementedError()

    @abstractmethod
    def close(self):
        """Delete session by using disconnect."""
        raise NotImplementedError()

    @abstractmethod
    def read(self):
        """Read data from the endpoint."""
        raise NotImplementedError()

    @abstractmethod
    def write(self):
        """Write data to the endpoint."""
        raise NotImplementedError()

    @property
    @abstractmethod
    def connected(self):
        """Give the connection status."""
        raise NotImplementedError()
